/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;

public class JythoncAntTask
extends MatchingTask {
    protected static final String JYTHONC_PY = "Tools/jythonc/jythonc.py";
    protected static final String JYTHON_CLASS = "org.python.util.jython";
    protected Path classpath;
    protected String packageName;
    protected File jarFile;
    protected File jythoncpy;
    protected boolean deep;
    protected boolean core;
    protected boolean all;
    protected String addpackages;
    protected File jarFileBean;
    protected String skipModule;
    protected String compiler;
    protected String compileropts;
    protected String falsenames;
    protected File jythonHome;
    protected File destDir;
    protected File srcDir;
    protected File workdir;
    protected String extraArgs;

    public JythoncAntTask() {
        this.setIncludes("**/*.py");
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspath(Path path) {
        this.classpath = path;
    }

    public void setPackage(String string) {
        this.packageName = string;
    }

    public void setJar(File file) {
        this.jarFile = file;
        this.deep = true;
    }

    public void setCore(boolean bl) {
        this.core = bl;
        this.deep = true;
    }

    public void setAll(boolean bl) {
        this.all = bl;
        this.deep = true;
    }

    public void setBean(File file) {
        this.jarFileBean = file;
    }

    public void setSkip(String string) {
        this.skipModule = string;
    }

    public void setDeep(boolean bl) {
        this.deep = bl;
    }

    public void setAddpackages(String string) {
        this.addpackages = string;
    }

    public void setWorkdir(File file) {
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new BuildException("Workdir (" + file + ") is not a directory");
            }
        } else {
            file.mkdirs();
        }
        this.workdir = file;
    }

    public void setCompiler(String string) {
        this.compiler = string;
    }

    public void setCompileropts(String string) {
        this.compileropts = string;
    }

    public void setFalsenames(String string) {
        this.falsenames = string;
    }

    public void setHome(File file) {
        this.jythonHome = file;
    }

    public void setSrcdir(File file) {
        this.srcDir = file;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setJythoncpy(File file) {
        this.jythoncpy = file;
    }

    public void setArgs(String string) {
        this.extraArgs = string;
    }

    public String getCompilerOptions() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.destDir != null) {
            stringBuffer.append("-d \"");
            stringBuffer.append(this.destDir);
            stringBuffer.append("\"");
            this.createClasspath().setLocation(this.destDir);
            this.destDir.mkdirs();
        }
        if (this.compileropts != null) {
            stringBuffer.append(this.compileropts);
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public File getPythonHome() {
        if (this.jythonHome == null) {
            String string = this.getProject().getProperty("python.home");
            if (string == null) {
                throw new BuildException("No python.home or home specified");
            }
            this.jythonHome = new File(string);
        }
        return this.jythonHome;
    }

    public File getJythoncPY() {
        if (this.jythoncpy == null) {
            return new File(this.getPythonHome(), JYTHONC_PY);
        }
        return this.jythoncpy;
    }

    public void execute() {
        try {
            String string;
            Java java = null;
            java = (Java)this.getProject().createTask("java");
            java.setTaskName("jythonc");
            java.setClassname(JYTHON_CLASS);
            java.createJvmarg().setValue("-Dpython.home=" + this.getPythonHome());
            File file = new File(this.getPythonHome(), "jython.jar");
            this.createClasspath().setLocation(file);
            java.setClasspath(this.classpath);
            java.createArg().setFile(this.getJythoncPY());
            if (this.packageName != null) {
                java.createArg().setValue("--package");
                java.createArg().setValue(this.packageName);
            }
            if (this.jarFile != null) {
                java.createArg().setValue("--jar");
                java.createArg().setFile(this.jarFile);
            }
            if (this.deep) {
                java.createArg().setValue("--deep");
            }
            if (this.core) {
                java.createArg().setValue("--core");
            }
            if (this.all) {
                java.createArg().setValue("--all");
            }
            if (this.jarFileBean != null) {
                java.createArg().setValue("--bean");
                java.createArg().setFile(this.jarFileBean);
            }
            if (this.addpackages != null) {
                java.createArg().setValue("--addpackages ");
                java.createArg().setValue(this.addpackages);
            }
            if (this.workdir != null) {
                java.createArg().setValue("--workdir ");
                java.createArg().setFile(this.workdir);
            }
            if (this.skipModule != null) {
                java.createArg().setValue("--skip");
                java.createArg().setValue(this.skipModule);
            }
            if (this.compiler == null) {
                string = this.getProject().getProperty("build.compiler");
                if (string != null && string.equals("jikes")) {
                    java.createArg().setValue("--compiler");
                    java.createArg().setValue("jikes");
                }
            } else {
                java.createArg().setValue("--compiler");
                java.createArg().setValue(this.compiler);
            }
            string = this.getCompilerOptions();
            if (string != null) {
                java.createArg().setValue("--compileropts");
                java.createArg().setValue(string);
            }
            if (this.falsenames != null) {
                java.createArg().setValue("--falsenames");
                java.createArg().setValue(this.falsenames);
            }
            if (this.extraArgs != null) {
                java.createArg().setLine(this.extraArgs);
            }
            if (this.srcDir == null) {
                this.srcDir = this.getProject().resolveFile(".");
            }
            DirectoryScanner directoryScanner = super.getDirectoryScanner(this.srcDir);
            String[] stringArray = directoryScanner.getIncludedFiles();
            this.log("compiling " + stringArray.length + " file" + (stringArray.length == 1 ? "" : "s"));
            String string2 = directoryScanner.getBasedir().toString() + File.separator;
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                java.createArg().setValue(string2 + string3);
            }
            java.setDir(this.srcDir);
            java.setFork(true);
            if (java.executeJava() != 0) {
                throw new BuildException("jythonc reported an error");
            }
        }
        catch (Exception exception) {
            String string = "Exception while calling org.python.util.jython. Details: " + exception.toString();
            throw new BuildException(string, (Throwable)exception);
        }
    }
}

